/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    long adjustmentHandle;
    int detail;
    boolean dragSent;

    ScrollBar() {
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.adjustmentHandle != 0L) {
            this.display.removeWidget(this.adjustmentHandle);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyScrollBar(this);
        this.releaseHandle();
    }

    public boolean getEnabled() {
        this.checkWidget();
        if (this.handle != 0L) {
            return GTK.gtk_widget_get_sensitive(this.handle);
        }
        return true;
    }

    @Override
    long gtk_button_press_event(long widget, long eventPtr) {
        long result = super.gtk_button_press_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        this.detail = 0;
        this.dragSent = false;
        return result;
    }

    @Override
    boolean gtk_change_value(long widget, int scroll, double value, long user_data) {
        this.detail = scroll;
        return false;
    }

    @Override
    long gtk_value_changed(long range) {
        Event event = new Event();
        this.dragSent = this.detail == 1;
        switch (this.detail) {
            case 0: {
                event.detail = 0;
                break;
            }
            case 1: {
                event.detail = 1;
                break;
            }
            case 14: {
                event.detail = 0x1000007;
                break;
            }
            case 15: {
                event.detail = 0x1000008;
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                event.detail = 0x1000006;
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                event.detail = 0x1000005;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                event.detail = 0x1000002;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                event.detail = 0x1000001;
            }
        }
        if (!this.dragSent) {
            this.detail = 0;
        }
        this.sendSelectionEvent(13, event, false);
        this.parent.updateScrollBarValue(this);
        GTK.gtk_widget_queue_draw(this.parent.handle);
        return 0L;
    }

    @Override
    long gtk_event_after(long widget, long gdkEvent) {
        int eventType = GDK.gdk_event_get_event_type(gdkEvent);
        eventType = Control.fixGdkEventTypeValues(eventType);
        switch (eventType) {
            case 7: {
                int[] eventButton = new int[1];
                if (GTK.GTK4) {
                    eventButton[0] = GDK.gdk_button_event_get_button(gdkEvent);
                } else {
                    GDK.gdk_event_get_button(gdkEvent, eventButton);
                }
                if (eventButton[0] == 1 && this.detail == 1) {
                    if (!this.dragSent) {
                        Event event = new Event();
                        event.detail = 1;
                        this.sendSelectionEvent(13, event, false);
                    }
                    this.sendSelectionEvent(13);
                }
                this.detail = 0;
                this.dragSent = false;
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.adjustmentHandle, OS.value_changed, this.display.getClosure(57), false);
        if (GTK.GTK4) {
            long clickGesture = GTK4.gtk_gesture_click_new();
            GTK4.gtk_widget_add_controller(this.handle, clickGesture);
            OS.g_signal_connect(clickGesture, OS.pressed, this.display.gesturePressReleaseProc, 100L);
        } else {
            OS.g_signal_connect_closure(this.handle, OS.change_value, this.display.getClosure(7), false);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        }
    }

    @Override
    void register() {
        super.register();
        if (this.adjustmentHandle != 0L) {
            this.display.addWidget(this.adjustmentHandle, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if (!((this.parent.style & 0x8000000) == 0 && create || (this.parent.state & 2) == 0 || (this.style & 0x100) == 0)) {
            GTK.gtk_range_set_inverted(this.handle, (this.parent.style & 0x4000000) != 0);
        }
    }
}

