/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.SVGRasterizer;

public class SVGFileFormat
extends FileFormat {
    private static final SVGRasterizer RASTERIZER = ServiceLoader.load(SVGRasterizer.class, SVGFileFormat.class.getClassLoader()).findFirst().orElse(null);

    @Override
    boolean isFileFormat(LEDataInputStream stream) throws IOException {
        byte[] firstBytes = new byte[5];
        int bytesRead = stream.read(firstBytes);
        stream.unread(firstBytes);
        String header = new String(firstBytes, 0, bytesRead, StandardCharsets.UTF_8).trim();
        return header.startsWith("<?xml") || header.startsWith("<svg");
    }

    @Override
    List<DPIUtil.ElementAtZoom<ImageData>> loadFromByteStream(int fileZoom, int targetZoom) {
        if (RASTERIZER == null) {
            SWT.error(42, null, " [No SVG rasterizer found]");
        }
        if (targetZoom <= 0) {
            SWT.error(5, null, " [Cannot rasterize SVG for zoom <= 0]");
        }
        try {
            ImageData rasterizedImageData = RASTERIZER.rasterizeSVG(this.inputStream, 100 * targetZoom / fileZoom);
            return List.of(new DPIUtil.ElementAtZoom<ImageData>(rasterizedImageData, targetZoom));
        }
        catch (IOException e) {
            SWT.error(40, e);
            return List.of();
        }
    }
}

