/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.feeders;

import java.util.Iterator;
import java.util.List;
import net.azib.ipscan.config.GUIConfig;
import net.azib.ipscan.feeders.Feeder;
import net.azib.ipscan.feeders.FeederCreator;
import net.azib.ipscan.feeders.FeederException;
import net.azib.ipscan.feeders.FeederRegistry;
import net.azib.ipscan.feeders.RescanFeeder;
import net.azib.ipscan.gui.feeders.AbstractFeederGUI;
import net.azib.ipscan.gui.feeders.FeederSelectionCombo;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.TableItem;

public class FeederGUIRegistry
implements FeederRegistry {
    private final List<AbstractFeederGUI> feederGUIList;
    private final Combo feederSelectionCombo;
    private final GUIConfig guiConfig;
    Feeder lastFeeder;
    private AbstractFeederGUI currentFeederGUI;

    public FeederGUIRegistry(List<AbstractFeederGUI> allTheFeeders, FeederSelectionCombo feederSelectionCombo, GUIConfig guiConfig) {
        this.feederGUIList = allTheFeeders;
        this.feederSelectionCombo = feederSelectionCombo;
        for (AbstractFeederGUI feederGUI : this.feederGUIList) {
            feederSelectionCombo.add(feederGUI.getFeederName());
        }
        this.guiConfig = guiConfig;
        this.currentFeederGUI = allTheFeeders.get(0);
        this.lastFeeder = this.currentFeederGUI.createFeeder();
    }

    public AbstractFeederGUI current() {
        return this.currentFeederGUI;
    }

    public void select(int newActiveFeeder) {
        this.currentFeederGUI.setVisible(false);
        this.currentFeederGUI = this.feederGUIList.get(newActiveFeeder);
        this.guiConfig.activeFeeder = newActiveFeeder;
        this.currentFeederGUI.setVisible(true);
    }

    @Override
    public Iterator<FeederCreator> iterator() {
        return this.feederGUIList.iterator();
    }

    @Override
    public void select(String feederId) {
        for (int i = 0; i < this.feederGUIList.size(); ++i) {
            AbstractFeederGUI guiFeeder = this.feederGUIList.get(i);
            if (!guiFeeder.getFeederId().equals(feederId) && !guiFeeder.getFeederName().equals(feederId)) continue;
            this.feederSelectionCombo.select(i);
            this.feederSelectionCombo.notifyListeners(13, null);
            return;
        }
        throw new FeederException("Feeder not found: " + feederId);
    }

    public Feeder createFeeder() {
        this.lastFeeder = this.current().createFeeder();
        return this.lastFeeder;
    }

    public Feeder createRescanFeeder(TableItem[] selection) {
        String[] addresses = new String[selection.length];
        for (int i = 0; i < selection.length; ++i) {
            addresses[i] = selection[i].getText();
        }
        return new RescanFeeder(this.lastFeeder, addresses);
    }
}

