/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.actions;

import java.net.InetAddress;
import net.azib.ipscan.config.GUIConfig;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.core.ScannerDispatcherThread;
import net.azib.ipscan.core.ScannerDispatcherThreadFactory;
import net.azib.ipscan.core.ScanningProgressCallback;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningResultCallback;
import net.azib.ipscan.core.net.PingerRegistry;
import net.azib.ipscan.core.state.ScanningState;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.core.state.StateTransitionListener;
import net.azib.ipscan.gui.ResultTable;
import net.azib.ipscan.gui.StatusBar;
import net.azib.ipscan.gui.feeders.FeederGUIRegistry;
import net.azib.ipscan.gui.util.LayoutHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;

public class StartStopScanningAction
implements ScanningProgressCallback,
StateTransitionListener,
SelectionListener {
    private ScannerDispatcherThreadFactory scannerThreadFactory;
    private ScannerDispatcherThread scannerThread;
    private GUIConfig guiConfig;
    private PingerRegistry pingerRegistry;
    private String mainWindowTitle;
    private StatusBar statusBar;
    private TaskItem taskBarItem;
    private ResultTable resultTable;
    private FeederGUIRegistry feederRegistry;
    private Button button;
    Image[] buttonImages = new Image[ScanningState.values().length];
    String[] buttonTexts = new String[ScanningState.values().length];
    private Display display;
    private StateMachine stateMachine;

    StartStopScanningAction(Display display) {
        this.display = display;
        this.buttonImages[ScanningState.IDLE.ordinal()] = LayoutHelper.icon("buttons/start");
        this.buttonImages[ScanningState.SCANNING.ordinal()] = LayoutHelper.icon("buttons/stop");
        this.buttonImages[ScanningState.STARTING.ordinal()] = this.buttonImages[ScanningState.SCANNING.ordinal()];
        this.buttonImages[ScanningState.RESTARTING.ordinal()] = this.buttonImages[ScanningState.SCANNING.ordinal()];
        this.buttonImages[ScanningState.STOPPING.ordinal()] = LayoutHelper.icon("buttons/kill");
        this.buttonImages[ScanningState.KILLING.ordinal()] = this.buttonImages[ScanningState.STOPPING.ordinal()];
        this.buttonTexts[ScanningState.IDLE.ordinal()] = Labels.getLabel("button.start");
        this.buttonTexts[ScanningState.SCANNING.ordinal()] = Labels.getLabel("button.stop");
        this.buttonTexts[ScanningState.STARTING.ordinal()] = this.buttonTexts[ScanningState.SCANNING.ordinal()];
        this.buttonTexts[ScanningState.RESTARTING.ordinal()] = this.buttonTexts[ScanningState.SCANNING.ordinal()];
        this.buttonTexts[ScanningState.STOPPING.ordinal()] = Labels.getLabel("button.kill");
        this.buttonTexts[ScanningState.KILLING.ordinal()] = Labels.getLabel("button.kill");
    }

    public StartStopScanningAction(ScannerDispatcherThreadFactory scannerThreadFactory, StateMachine stateMachine, ResultTable resultTable, StatusBar statusBar, FeederGUIRegistry feederRegistry, PingerRegistry pingerRegistry, Button startStopButton, GUIConfig guiConfig) {
        this(startStopButton.getDisplay());
        this.scannerThreadFactory = scannerThreadFactory;
        this.resultTable = resultTable;
        this.statusBar = statusBar;
        this.feederRegistry = feederRegistry;
        this.pingerRegistry = pingerRegistry;
        this.button = startStopButton;
        this.stateMachine = stateMachine;
        this.guiConfig = guiConfig;
        this.taskBarItem = this.getTaskBarItem();
        stateMachine.addTransitionListener(this);
        ScanningState state = stateMachine.getState();
        this.button.setImage(this.buttonImages[state.ordinal()]);
        this.button.setText(this.buttonTexts[state.ordinal()]);
    }

    private TaskItem getTaskBarItem() {
        TaskBar bar = this.display.getSystemTaskBar();
        if (bar == null || Platform.MAC_OS) {
            return null;
        }
        TaskItem item = bar.getItem(this.statusBar.getShell());
        if (item == null) {
            item = bar.getItem(null);
        }
        if (item != null) {
            item.setProgressState(0);
        }
        return item;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent event) {
        if (this.stateMachine.inState(ScanningState.IDLE) && !this.preScanChecks()) {
            return;
        }
        this.stateMachine.transitionToNext();
    }

    private boolean preScanChecks() {
        if (this.guiConfig.askScanConfirmation && this.resultTable.getItemCount() > 0) {
            MessageBox box = new MessageBox(this.resultTable.getShell(), 268435652);
            box.setText(Labels.getLabel("text.scan.new"));
            box.setMessage(Labels.getLabel("text.scan.confirmation"));
            return box.open() == 64;
        }
        return true;
    }

    @Override
    public void transitionTo(ScanningState state, StateMachine.Transition transition) {
        if (this.statusBar.isDisposed() || transition == StateMachine.Transition.INIT) {
            return;
        }
        switch (state) {
            case IDLE: {
                this.button.setEnabled(true);
                this.updateProgress(null, 0, 0);
                this.statusBar.setStatusText(null);
                break;
            }
            case STARTING: {
                if (transition != StateMachine.Transition.CONTINUE) {
                    this.resultTable.removeAll();
                }
                try {
                    this.scannerThread = this.scannerThreadFactory.createScannerThread(this.feederRegistry.createFeeder(), this, this.createResultsCallback(state));
                    this.stateMachine.startScanning();
                    this.mainWindowTitle = this.statusBar.getShell().getText();
                    break;
                }
                catch (RuntimeException e) {
                    this.stateMachine.reset();
                    throw e;
                }
            }
            case RESTARTING: {
                this.resultTable.resetSelection();
                try {
                    this.scannerThread = this.scannerThreadFactory.createScannerThread(this.feederRegistry.createRescanFeeder(this.resultTable.getSelection()), this, this.createResultsCallback(state));
                    this.stateMachine.startScanning();
                    this.mainWindowTitle = this.statusBar.getShell().getText();
                    break;
                }
                catch (RuntimeException e) {
                    this.stateMachine.reset();
                    throw e;
                }
            }
            case SCANNING: {
                this.scannerThread.start();
                break;
            }
            case STOPPING: {
                this.statusBar.setStatusText(Labels.getLabel("state.waitForThreads"));
                break;
            }
            case KILLING: {
                this.button.setEnabled(false);
                this.statusBar.setStatusText(Labels.getLabel("state.killingThreads"));
            }
        }
        this.button.setImage(this.buttonImages[state.ordinal()]);
        this.button.setText(this.buttonTexts[state.ordinal()]);
    }

    private ScanningResultCallback createResultsCallback(ScanningState state) {
        if (this.guiConfig.displayMethod == GUIConfig.DisplayMethod.ALL || state == ScanningState.RESTARTING) {
            return new ScanningResultCallback(){

                @Override
                public void prepareForResults(ScanningResult result) {
                    StartStopScanningAction.this.resultTable.addOrUpdateResultRow(result);
                }

                @Override
                public void consumeResults(ScanningResult result) {
                    StartStopScanningAction.this.resultTable.addOrUpdateResultRow(result);
                }
            };
        }
        if (this.guiConfig.displayMethod == GUIConfig.DisplayMethod.ALIVE) {
            return new ScanningResultCallback(){

                @Override
                public void prepareForResults(ScanningResult result) {
                }

                @Override
                public void consumeResults(ScanningResult result) {
                    if (result.getType().ordinal() >= ScanningResult.ResultType.ALIVE.ordinal()) {
                        StartStopScanningAction.this.resultTable.addOrUpdateResultRow(result);
                    }
                }
            };
        }
        if (this.guiConfig.displayMethod == GUIConfig.DisplayMethod.PORTS) {
            return new ScanningResultCallback(){

                @Override
                public void prepareForResults(ScanningResult result) {
                }

                @Override
                public void consumeResults(ScanningResult result) {
                    if (result.getType() == ScanningResult.ResultType.WITH_PORTS) {
                        StartStopScanningAction.this.resultTable.addOrUpdateResultRow(result);
                    }
                }
            };
        }
        throw new UnsupportedOperationException(this.guiConfig.displayMethod.toString());
    }

    @Override
    public void updateProgress(InetAddress currentAddress, int runningThreads, int percentageComplete) {
        if (this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec(() -> {
            if (this.statusBar.isDisposed()) {
                return;
            }
            if (currentAddress != null) {
                this.statusBar.setStatusText(Labels.getLabel("state.scanning") + currentAddress.getHostAddress());
            }
            this.statusBar.setRunningThreads(runningThreads);
            this.statusBar.setProgress(percentageComplete);
            if (this.taskBarItem != null) {
                this.taskBarItem.setProgress(percentageComplete);
            }
            if (!this.stateMachine.inState(ScanningState.IDLE)) {
                this.statusBar.getShell().setText(percentageComplete + "% - " + this.mainWindowTitle);
            } else {
                this.statusBar.getShell().setText(this.mainWindowTitle);
            }
            this.button.setImage(this.buttonImages[this.stateMachine.getState().ordinal()]);
        });
    }
}

