/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.actions;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.config.CommandLineProcessor;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.Version;
import net.azib.ipscan.gui.AboutDialog;
import net.azib.ipscan.gui.GettingStartedDialog;
import net.azib.ipscan.gui.InfoDialog;
import net.azib.ipscan.gui.StatusBar;
import net.azib.ipscan.gui.actions.BrowserLauncher;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;

public class HelpMenuActions {

    public static final class CheckVersion
    implements Listener {
        private final StatusBar statusBar;

        public CheckVersion(StatusBar statusBar) {
            this.statusBar = statusBar;
        }

        @Override
        public void handleEvent(Event event) {
            this.check(true);
        }

        public void check(boolean userRequest) {
            this.statusBar.setStatusText(Labels.getLabel("state.retrievingVersion"));
            Runnable checkVersionCode = () -> {
                String message = null;
                int messageStyle = 2;
                try {
                    URL url = new URL("https://angryip.org/ipscan/IPSCAN.VERSION");
                    URLConnection conn = url.openConnection();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                        String latestVersion = reader.readLine();
                        latestVersion = latestVersion.substring(latestVersion.indexOf(32) + 1);
                        if (!Version.getVersion().equals(latestVersion)) {
                            message = Labels.getLabel("text.version.old");
                            message = message.replaceFirst("%LATEST", latestVersion);
                            message = message.replaceFirst("%VERSION", Version.getVersion());
                            messageStyle = 196;
                        } else if (userRequest) {
                            message = Labels.getLabel("text.version.latest");
                            messageStyle = 2;
                        }
                    }
                }
                catch (Exception e) {
                    if (userRequest) {
                        message = Labels.getLabel("exception.UserErrorException.version.latestFailed");
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, message, e);
                }
                finally {
                    String messageToShow = message;
                    int messageStyleToShow = messageStyle;
                    Display.getDefault().asyncExec(() -> {
                        this.statusBar.setStatusText(null);
                        if (messageToShow == null) {
                            return;
                        }
                        MessageBox messageBox = new MessageBox(this.statusBar.getShell(), messageStyleToShow | 0x10000000);
                        messageBox.setText(Version.getFullName());
                        messageBox.setMessage(messageToShow);
                        if (messageBox.open() == 64) {
                            BrowserLauncher.openURL("https://angryip.org/download/");
                        }
                    });
                }
            };
            new Thread(checkVersionCode).start();
        }
    }

    public static final class Plugins
    implements Listener {
        @Override
        public void handleEvent(Event event) {
            BrowserLauncher.openURL("https://angryip.org/contribute/plugins.html");
        }
    }

    public static final class Issues
    implements Listener {
        @Override
        public void handleEvent(Event event) {
            BrowserLauncher.openURL("https://angryip.org/issues/");
        }
    }

    public static final class FAQ
    implements Listener {
        @Override
        public void handleEvent(Event event) {
            BrowserLauncher.openURL("https://angryip.org/faq/");
        }
    }

    public static final class Website
    implements Listener {
        @Override
        public void handleEvent(Event event) {
            BrowserLauncher.openURL("https://angryip.org");
        }
    }

    public static final class About
    implements Listener {
        private AboutDialog aboutDialog;

        public About(AboutDialog aboutDialog) {
            this.aboutDialog = aboutDialog;
        }

        @Override
        public void handleEvent(Event event) {
            this.aboutDialog.open();
        }
    }

    public static final class CommandLineUsage
    implements Listener {
        private CommandLineProcessor cli;

        public CommandLineUsage(CommandLineProcessor cli) {
            this.cli = cli;
        }

        @Override
        public void handleEvent(Event event) {
            InfoDialog dialog = new InfoDialog("Angry IP Scanner", Labels.getLabel("title.commandline"));
            dialog.setMessage(this.cli.toString());
            dialog.open();
        }
    }

    public static final class GettingStarted
    implements Listener {
        @Override
        public void handleEvent(Event event) {
            new GettingStartedDialog().open();
        }
    }
}

