/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import java.text.DecimalFormat;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.core.ScanningResultList;
import net.azib.ipscan.core.UserErrorException;
import net.azib.ipscan.gui.InfoDialog;

public class StatisticsDialog
extends InfoDialog {
    private final ScanningResultList scanningResults;

    public StatisticsDialog(ScanningResultList scanningResults) {
        super(Labels.getLabel("title.statistics"), null);
        this.scanningResults = scanningResults;
    }

    @Override
    public void open() {
        if (this.scanningResults.isInfoAvailable()) {
            this.setMessage(this.prepareText());
            if (this.shell != null) {
                this.close();
            }
        } else {
            throw new UserErrorException("commands.noResults");
        }
        super.open();
    }

    String prepareText() {
        ScanningResultList.ScanInfo scanInfo = this.scanningResults.getScanInfo();
        this.title2 = Labels.getLabel(scanInfo.isCompletedNormally() ? "text.scan.completed" : "text.scan.incomplete");
        String ln = System.getProperty("line.separator");
        StringBuilder text = new StringBuilder();
        text.append(Labels.getLabel("text.scan.time.total")).append(StatisticsDialog.timeToText(scanInfo.getScanTime())).append(ln);
        text.append(Labels.getLabel("text.scan.time.average")).append(StatisticsDialog.timeToText((double)scanInfo.getScanTime() / (double)scanInfo.getHostCount())).append(ln);
        text.append(ln).append(this.scanningResults.getFeederName()).append(ln).append(this.scanningResults.getFeederInfo()).append(ln).append(ln);
        text.append(Labels.getLabel("text.scan.hosts.total")).append(scanInfo.getHostCount()).append(ln);
        text.append(Labels.getLabel("text.scan.hosts.alive")).append(scanInfo.getAliveCount()).append(ln);
        if (scanInfo.getWithPortsCount() > 0) {
            text.append(Labels.getLabel("text.scan.hosts.ports")).append(scanInfo.getWithPortsCount()).append(ln);
        }
        return text.toString();
    }

    static String timeToText(double scanTime) {
        double totalSeconds = scanTime / 1000.0;
        double totalMinutes = totalSeconds / 60.0;
        double totalHours = totalMinutes / 60.0;
        DecimalFormat format = new DecimalFormat("#.##");
        if (totalHours >= 1.0) {
            return format.format(totalHours) + Labels.getLabel("unit.hour");
        }
        if (totalMinutes >= 1.0) {
            return format.format(totalMinutes) + Labels.getLabel("unit.minute");
        }
        return format.format(totalSeconds) + Labels.getLabel("unit.second");
    }
}

