/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import net.azib.ipscan.config.Labels;
import net.azib.ipscan.core.state.ScanningState;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.core.state.StateTransitionListener;
import net.azib.ipscan.gui.menu.AbstractMenu;
import net.azib.ipscan.gui.menu.CommandsMenu;
import net.azib.ipscan.gui.menu.FavoritesMenu;
import net.azib.ipscan.gui.menu.GotoMenu;
import net.azib.ipscan.gui.menu.HelpMenu;
import net.azib.ipscan.gui.menu.ResultsContextMenu;
import net.azib.ipscan.gui.menu.ScanMenu;
import net.azib.ipscan.gui.menu.ToolsMenu;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class MainMenu {
    public MainMenu(Shell parent, Menu mainMenu, ScanMenu scanMenu, GotoMenu gotoMenu, CommandsMenu commandsMenu, FavoritesMenu favoritesMenu, ToolsMenu toolsMenu, HelpMenu helpMenu, ResultsContextMenu resultsContextMenu, StateMachine stateMachine) {
        parent.setMenuBar(mainMenu);
        this.addMenuItem(mainMenu, scanMenu);
        this.addMenuItem(mainMenu, gotoMenu);
        this.addMenuItem(mainMenu, commandsMenu);
        this.addMenuItem(mainMenu, favoritesMenu);
        this.addMenuItem(mainMenu, toolsMenu);
        this.addMenuItem(mainMenu, helpMenu);
        stateMachine.addTransitionListener(new MenuEnablerDisabler(mainMenu));
        stateMachine.addTransitionListener(new MenuEnablerDisabler(resultsContextMenu));
    }

    private void addMenuItem(Menu mainMenu, AbstractMenu menu) {
        MenuItem menuItem = new MenuItem(mainMenu, 64);
        menuItem.setText(Labels.getLabel(menu.getId()));
        menuItem.setMenu(menu);
    }

    public static class MenuEnablerDisabler
    implements StateTransitionListener {
        private Menu menu;

        public MenuEnablerDisabler(Menu menu) {
            this.menu = menu;
        }

        @Override
        public void transitionTo(ScanningState state, StateMachine.Transition transition) {
            if (transition != StateMachine.Transition.START && transition != StateMachine.Transition.COMPLETE) {
                return;
            }
            this.processMenu(this.menu, state == ScanningState.IDLE);
        }

        public void processMenu(Menu menu, boolean isEnabled) {
            for (MenuItem item : menu.getItems()) {
                if (item.getData("disableDuringScanning") == Boolean.TRUE) {
                    item.setEnabled(isEnabled);
                    continue;
                }
                if (item.getMenu() == null) continue;
                this.processMenu(item.getMenu(), isEnabled);
            }
        }
    }
}

