/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.SocketException;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.fetchers.MACFetcher;
import net.azib.ipscan.util.IOUtils;

public class UnixMACFetcher
extends MACFetcher {
    private String arp = Platform.LINUX ? "arp -an " : "arp -n ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String resolveMAC(ScanningSubject subject) {
        String string;
        String ip = subject.getAddress().getHostAddress();
        BufferedReader reader = null;
        try {
            String line;
            Process process = Runtime.getRuntime().exec(this.arp + ip);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.contains(ip)) continue;
                String string2 = this.extractMAC(line);
                IOUtils.closeQuietly(reader);
                return string2;
            }
            string = UnixMACFetcher.getLocalMAC(subject);
            IOUtils.closeQuietly(reader);
        }
        catch (Exception e) {
            String string3 = null;
            return string3;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        return string;
    }

    static String getLocalMAC(ScanningSubject subject) throws SocketException {
        return subject.isLocalHost() ? UnixMACFetcher.bytesToMAC(subject.getInterface().getHardwareAddress()) : null;
    }
}

