/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.fetchers.AbstractFetcher;
import net.azib.ipscan.fetchers.MACFetcher;

public class MACVendorFetcher
extends AbstractFetcher {
    private static Map<String, String> vendors = new HashMap<String, String>();
    private MACFetcher macFetcher;

    public MACVendorFetcher(MACFetcher macFetcher) {
        this.macFetcher = macFetcher;
    }

    @Override
    public String getId() {
        return "fetcher.mac.vendor";
    }

    @Override
    public void init() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/mac-vendors.txt")));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                vendors.put(line.substring(0, 6), line.substring(6));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object scan(ScanningSubject subject) {
        String mac = (String)subject.getParameter("fetcher.mac");
        if (mac == null) {
            this.macFetcher.scan(subject);
            mac = (String)subject.getParameter("fetcher.mac");
        }
        return mac != null ? this.findMACVendor(mac) : null;
    }

    String findMACVendor(String mac) {
        return vendors.get(mac.replace(":", "").substring(0, 6));
    }
}

