/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Logger;

public final class Labels {
    public static final String[] LANGUAGES = new String[]{"system", "en", "ru", "de", "hu", "lt", "es", "fi", "fr", "it", "ga_IE", "ku", "tr", "gr", "pt_BR", "zh_CN", "zh_TW"};
    private static final Logger LOG = Logger.getLogger(Labels.class.getName());
    private static Labels instance;
    Locale locale;
    Properties labels = new Properties();
    Properties fallback = new Properties();

    Labels(Locale locale) {
        this.locale = locale;
        this.load(this.getClass().getClassLoader());
    }

    public static Labels getInstance() {
        return instance;
    }

    public static void initialize(Locale locale) {
        if (instance != null && locale.equals(Labels.instance.locale)) {
            return;
        }
        instance = new Labels(locale);
    }

    public void load(ClassLoader loader) {
        InputStream in;
        try {
            in = loader.getResourceAsStream("messages.properties");
            try {
                if (in != null) {
                    this.fallback.load(new InputStreamReader(in, StandardCharsets.UTF_8));
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw new MissingResourceException(e.toString(), Labels.class.getName(), "messages");
        }
        try {
            in = loader.getResourceAsStream("messages_" + this.locale.toString() + ".properties");
            try {
                this.labels.load(new InputStreamReader(in, StandardCharsets.UTF_8));
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Exception e) {
            try (InputStream in2 = loader.getResourceAsStream("messages_" + this.locale.getLanguage() + ".properties");){
                this.labels.load(new InputStreamReader(in2, StandardCharsets.UTF_8));
            }
            catch (Exception e2) {
                this.labels = this.fallback;
            }
        }
    }

    public String getOrNull(String key) {
        String text = this.labels.getProperty(key);
        if (text == null && (text = this.fallback.getProperty(key)) != null && !key.startsWith("language.")) {
            LOG.warning("Used fallback label for " + key);
        }
        return text;
    }

    public String get(String key) {
        String text = this.getOrNull(key);
        if (text == null) {
            text = key;
            LOG.warning("Missing label for " + key);
        }
        return text;
    }

    public static String getLabel(String key) {
        return Labels.getInstance().get(key);
    }

    static {
        Labels.initialize(Locale.getDefault());
    }
}

