/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

class PngChunk {
    byte[] reference;
    static final int LENGTH_OFFSET = 0;
    static final int TYPE_OFFSET = 4;
    static final int DATA_OFFSET = 8;
    static final int TYPE_FIELD_LENGTH = 4;
    static final int LENGTH_FIELD_LENGTH = 4;
    static final int MIN_LENGTH = 12;
    static final int CHUNK_UNKNOWN = -1;
    static final int CHUNK_IHDR = 0;
    static final int CHUNK_PLTE = 1;
    static final int CHUNK_IDAT = 2;
    static final int CHUNK_IEND = 3;
    static final int CHUNK_tRNS = 5;
    static final byte[] TYPE_IHDR = new byte[]{73, 72, 68, 82};
    static final byte[] TYPE_PLTE = new byte[]{80, 76, 84, 69};
    static final byte[] TYPE_IDAT = new byte[]{73, 68, 65, 84};
    static final byte[] TYPE_IEND = new byte[]{73, 69, 78, 68};
    static final byte[] TYPE_tRNS = new byte[]{116, 82, 78, 83};
    static final int[] CRC_TABLE = new int[256];
    int length;

    static {
        int i = 0;
        while (i < 256) {
            PngChunk.CRC_TABLE[i] = i;
            int j = 0;
            while (j < 8) {
                PngChunk.CRC_TABLE[i] = (CRC_TABLE[i] & 1) == 0 ? CRC_TABLE[i] >> 1 & Integer.MAX_VALUE : 0xEDB88320 ^ CRC_TABLE[i] >> 1 & Integer.MAX_VALUE;
                ++j;
            }
            ++i;
        }
    }

    int getInt32(int offset) {
        int answer = 0;
        answer |= (this.reference[offset] & 0xFF) << 24;
        answer |= (this.reference[offset + 1] & 0xFF) << 16;
        answer |= (this.reference[offset + 2] & 0xFF) << 8;
        return answer |= this.reference[offset + 3] & 0xFF;
    }

    int getLength() {
        return this.length;
    }

    byte[] getTypeBytes() {
        byte[] type = new byte[4];
        System.arraycopy(this.reference, 4, type, 0, 4);
        return type;
    }

    int getCRC() {
        int crcOffset = 8 + this.getLength();
        return this.getInt32(crcOffset);
    }

    void contributeToString(StringBuilder buffer) {
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        buffer.append("\n\tLength: ");
        buffer.append(this.getLength());
        buffer.append("\n\tType: ");
        byte[] byArray = this.getTypeBytes();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            buffer.append((char)element);
            ++n2;
        }
        this.contributeToString(buffer);
        buffer.append("\n\tCRC: ");
        buffer.append(Integer.toHexString(this.getCRC()));
        buffer.append("\n}");
        return buffer.toString();
    }
}

