/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_rectangle_int_t;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.OS;

public final class Region
extends Resource {
    public long handle = Cairo.cairo_region_create();

    public Region() {
        this(null);
    }

    public Region(Device device) {
        super(device);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    static long gdk_region_polygon(int[] pointArray, int npoints, int fill_rule) {
        long cairo;
        int minY;
        int minX;
        int maxX = minX = pointArray[0];
        int maxY = minY = pointArray[1];
        int count = npoints * 2;
        int i = 2;
        while (i < count) {
            int x = pointArray[i];
            int y = pointArray[i + 1];
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y > maxY) {
                maxY = y;
            }
            i += 2;
        }
        long surface = Cairo.cairo_image_surface_create(0, maxX - minX, maxY - minY);
        if (surface == 0L) {
            SWT.error(2);
        }
        if ((cairo = Cairo.cairo_create(surface)) == 0L) {
            SWT.error(2);
        }
        Cairo.cairo_move_to(cairo, pointArray[0] - minX, pointArray[1] - minY);
        int i2 = 2;
        while (i2 < count) {
            Cairo.cairo_line_to(cairo, pointArray[i2] - minX, pointArray[i2 + 1] - minY);
            i2 += 2;
        }
        Cairo.cairo_close_path(cairo);
        Cairo.cairo_set_source_rgb(cairo, 1.0, 1.0, 1.0);
        int cairo_rule = 0;
        if (fill_rule == 0) {
            cairo_rule = 1;
        }
        Cairo.cairo_set_fill_rule(cairo, cairo_rule);
        Cairo.cairo_fill(cairo);
        Cairo.cairo_destroy(cairo);
        long polyRgn = GDK.gdk_cairo_region_create_from_surface(surface);
        Cairo.cairo_region_translate(polyRgn, minX, minY);
        Cairo.cairo_surface_destroy(surface);
        return polyRgn;
    }

    static void cairo_region_get_rectangles(long region, long[] rectangles, int[] n_rectangles) {
        int num = Cairo.cairo_region_num_rectangles(region);
        if (n_rectangles != null) {
            n_rectangles[0] = num;
        }
        rectangles[0] = OS.g_malloc(cairo_rectangle_int_t.sizeof * num);
        int n = 0;
        while (n < num) {
            Cairo.cairo_region_get_rectangle(region, n, rectangles[0] + (long)(n * cairo_rectangle_int_t.sizeof));
            ++n;
        }
    }

    public void add(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        this.addInPixels(DPIUtil.autoScaleUp(pointArray));
    }

    void addInPixels(int[] pointArray) {
        if (pointArray.length < 6) {
            return;
        }
        long polyRgn = Region.gdk_region_polygon(pointArray, pointArray.length / 2, 0);
        Cairo.cairo_region_union(this.handle, polyRgn);
        Cairo.cairo_region_destroy(polyRgn);
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.addInPixels(DPIUtil.autoScaleUp(rect));
    }

    void addInPixels(Rectangle rect) {
        this.addInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    void addInPixels(int x, int y, int width, int height) {
        cairo_rectangle_int_t rect = new cairo_rectangle_int_t();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        Cairo.cairo_region_union_rectangle(this.handle, rect);
    }

    @Override
    void destroy() {
        Cairo.cairo_region_destroy(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        cairo_rectangle_int_t rect = new cairo_rectangle_int_t();
        Cairo.cairo_region_get_extents(this.handle, rect);
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public int hashCode() {
        return (int)this.handle;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

