/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;

public final class Cursor
extends Resource {
    public long handle;

    public Cursor(Device device, int style) {
        super(device);
        String name1 = null;
        String name2 = null;
        switch (style) {
            case 3: {
                name1 = "left_ptr_watch";
                break;
            }
            case 0: {
                name1 = "left_ptr";
                break;
            }
            case 1: {
                name1 = "watch";
                break;
            }
            case 2: {
                name1 = "crosshair";
                break;
            }
            case 21: {
                name1 = "hand2";
                break;
            }
            case 4: {
                name1 = "question_arrow";
                break;
            }
            case 5: {
                name1 = "fleur";
                break;
            }
            case 6: {
                name1 = "size_bdiag";
                break;
            }
            case 7: {
                name1 = "sb_v_double_arrow";
                break;
            }
            case 8: {
                name1 = "size_fdiag";
                break;
            }
            case 9: {
                name1 = "sb_h_double_arrow";
                break;
            }
            case 10: {
                name1 = "top_side";
                break;
            }
            case 11: {
                name1 = "bottom_side";
                break;
            }
            case 12: {
                name1 = "right_side";
                break;
            }
            case 13: {
                name1 = "left_side";
                break;
            }
            case 14: {
                name1 = "top_right_corner";
                break;
            }
            case 15: {
                name1 = "bottom_right_corner";
                break;
            }
            case 16: {
                name1 = "bottom_left_corner";
                break;
            }
            case 17: {
                name1 = "top_left_corner";
                break;
            }
            case 18: {
                name1 = "sb_up_arrow";
                name2 = "up-arrow";
                break;
            }
            case 19: {
                name1 = "xterm";
                break;
            }
            case 20: {
                name1 = "crossed_circle";
                name2 = "not-allowed";
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        String[] stringArray = new String[]{name1, name2, "left_ptr", "default"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name != null) {
                this.handle = GTK.GTK4 ? GDK.gdk_cursor_new_from_name(name, 0L) : GDK.gdk_cursor_new_from_name(GDK.gdk_display_get_default(), name);
                if (this.handle != 0L) break;
            }
            ++n2;
        }
        if (this.handle == 0L) {
            SWT.error(2);
        }
        this.init();
    }

    @Override
    void destroy() {
        OS.g_object_unref(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }
}

