/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();
    private static final int COMPOUND_TEXT_ID = GTK.GTK4 ? 0 : TextTransfer.registerType("COMPOUND_TEXT");
    private static final int UTF8_STRING_ID = GTK.GTK4 ? 0 : TextTransfer.registerType("UTF8_STRING");
    private static final int STRING_ID = GTK.GTK4 ? 0 : TextTransfer.registerType("STRING");
    private static final int TEXT_PLAIN_UTF8_ID = GTK.GTK4 ? 0 : TextTransfer.registerType("text/plain;charset=utf-8");

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        byte[] utf8 = Converter.wcsToMbcs(string, true);
        if (OS.isX11() && transferData.type == (long)COMPOUND_TEXT_ID) {
            long[] encoding = new long[1];
            int[] format = new int[1];
            long[] ctext = new long[1];
            int[] length = new int[1];
            boolean result = GDK.gdk_x11_display_utf8_to_compound_text(GDK.gdk_display_get_default(), utf8, encoding, format, ctext, length);
            if (!result) {
                return;
            }
            transferData.type = encoding[0];
            transferData.format = format[0];
            transferData.length = length[0];
            transferData.pValue = ctext[0];
            transferData.result = 1;
        }
        if (transferData.type == (long)UTF8_STRING_ID || transferData.type == (long)TEXT_PLAIN_UTF8_ID) {
            long pValue = OS.g_malloc(utf8.length);
            if (pValue == 0L) {
                return;
            }
            C.memmove(pValue, utf8, (long)utf8.length);
            transferData.format = 8;
            transferData.length = utf8.length - 1;
            transferData.pValue = pValue;
            transferData.result = 1;
        }
        if (transferData.type == (long)STRING_ID) {
            long string_target = GDK.gdk_utf8_to_string_target(utf8);
            if (string_target == 0L) {
                return;
            }
            transferData.type = STRING_ID;
            transferData.format = 8;
            transferData.length = C.strlen(string_target);
            transferData.pValue = string_target;
            transferData.result = 1;
        }
    }

    @Override
    protected int[] getTypeIds() {
        if (OS.isX11()) {
            return new int[]{UTF8_STRING_ID, COMPOUND_TEXT_ID, STRING_ID};
        }
        if (GTK.GTK4) {
            return new int[]{(int)OS.G_TYPE_STRING()};
        }
        return new int[]{UTF8_STRING_ID, STRING_ID, TEXT_PLAIN_UTF8_ID};
    }

    @Override
    protected String[] getTypeNames() {
        if (OS.isX11()) {
            return new String[]{"UTF8_STRING", "COMPOUND_TEXT", "STRING"};
        }
        if (GTK.GTK4) {
            return new String[]{"text/plain", "STRING"};
        }
        return new String[]{"UTF8_STRING", "STRING", "text/plain;charset=utf-8"};
    }

    boolean checkText(Object object) {
        return object instanceof String && !((String)object).isEmpty();
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

