/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.actions;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.feeders.FeederException;
import net.azib.ipscan.util.InetAddressUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class FeederActions {
    static final Logger LOG = LoggerFactory.getLogger();

    public static class HostnameButton
    extends SelectionAdapter
    implements TraverseListener {
        private Text hostnameText;
        private Text ipText;
        private Combo netmaskCombo;

        public HostnameButton(Text hostnameText, Text ipText, Combo netmaskCombo) {
            this.hostnameText = hostnameText;
            this.ipText = ipText;
            this.netmaskCombo = netmaskCombo;
        }

        @Override
        public void widgetSelected(SelectionEvent event) {
            String hostname = this.hostnameText.getText();
            try {
                if (hostname.equals(InetAddress.getLocalHost().getHostName())) {
                    this.askLocalIPAddress();
                } else {
                    InetAddress address = InetAddress.getByName(hostname);
                    this.ipText.setText(address.getHostAddress());
                    String realHostname = address.getCanonicalHostName();
                    if (!address.getHostAddress().equals(realHostname)) {
                        this.hostnameText.setText(realHostname);
                        this.hostnameText.setSelection(realHostname.length());
                    }
                }
            }
            catch (UnknownHostException e) {
                throw new FeederException("invalidHostname");
            }
        }

        @Override
        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 4) {
                this.widgetSelected(null);
                e.doit = false;
            }
        }

        private void askLocalIPAddress() {
            try {
                Menu popupMenu = new Menu(Display.getCurrent().getActiveShell(), 8);
                Listener menuItemListener = event -> {
                    MenuItem menuItem = (MenuItem)event.widget;
                    InterfaceAddress ifAddr = (InterfaceAddress)menuItem.getData();
                    this.ipText.setText(ifAddr.getAddress().getHostAddress());
                    this.netmaskCombo.setText("/" + ifAddr.getNetworkPrefixLength());
                    this.setInterfaceAddress(ifAddr);
                    menuItem.getParent().dispose();
                };
                for (NetworkInterface networkInterface : InetAddressUtils.getNetworkInterfaces()) {
                    List<InterfaceAddress> addresses = networkInterface.getInterfaceAddresses();
                    addresses.sort(Comparator.comparing(i -> i.getAddress().getAddress().length));
                    for (InterfaceAddress ifaddr : addresses) {
                        InetAddress address;
                        if (ifaddr == null || (address = ifaddr.getAddress()).isLoopbackAddress()) continue;
                        MenuItem menuItem = new MenuItem(popupMenu, 0);
                        String ip = address.getHostAddress();
                        menuItem.setText(networkInterface.getDisplayName() + ": " + ip + "/" + ifaddr.getNetworkPrefixLength());
                        menuItem.setData(ifaddr);
                        menuItem.addListener(13, menuItemListener);
                    }
                }
                if (popupMenu.getItemCount() > 1) {
                    popupMenu.setLocation(Display.getCurrent().getCursorLocation());
                    popupMenu.setVisible(true);
                } else if (popupMenu.getItemCount() == 1) {
                    Event event2 = new Event();
                    event2.widget = popupMenu.getItem(0);
                    menuItemListener.handleEvent(event2);
                    popupMenu.dispose();
                }
            }
            catch (SocketException e) {
                LOG.log(Level.FINE, "Cannot enumerate network interfaces", e);
            }
        }

        protected void setInterfaceAddress(InterfaceAddress ifAddr) {
        }
    }
}

