/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import net.azib.ipscan.config.Config;
import net.azib.ipscan.config.GUIConfig;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.ScannerConfig;
import net.azib.ipscan.core.PortIterator;
import net.azib.ipscan.core.net.PingerRegistry;
import net.azib.ipscan.fetchers.FetcherException;
import net.azib.ipscan.gui.AbstractModalDialog;
import net.azib.ipscan.gui.util.LayoutHelper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PreferencesDialog
extends AbstractModalDialog {
    private final PingerRegistry pingerRegistry;
    private final Config globalConfig;
    private final ScannerConfig scannerConfig;
    private final GUIConfig guiConfig;
    private Button okButton;
    private Button cancelButton;
    private TabFolder tabFolder;
    private Composite scanningTab;
    private TabItem scanningTabItem;
    private Composite displayTab;
    private Text threadDelayText;
    private Text maxThreadsText;
    private Button deadHostsCheckbox;
    private Text pingingTimeoutText;
    private Text pingingCountText;
    private Combo pingersCombo;
    private Button skipBroadcastsCheckbox;
    private Composite portsTab;
    private TabItem portsTabItem;
    private Text portTimeoutText;
    private Button adaptTimeoutCheckbox;
    private Button addRequestedPortsCheckbox;
    private Text minPortTimeoutText;
    private Text portsText;
    private Text notAvailableText;
    private Text notScannedText;
    private Button[] displayMethod;
    private Button showInfoCheckbox;
    private Button askConfirmationCheckbox;
    private Button versionCheckCheckbox;
    private Button allowReports;
    private Combo languageCombo;

    public PreferencesDialog(PingerRegistry pingerRegistry, Config globalConfig, ScannerConfig scannerConfig, GUIConfig guiConfig) {
        this.pingerRegistry = pingerRegistry;
        this.globalConfig = globalConfig;
        this.scannerConfig = scannerConfig;
        this.guiConfig = guiConfig;
    }

    @Override
    public void open() {
        this.openTab(0);
    }

    public void openTab(int tabIndex) {
        this.createShell();
        this.loadPreferences();
        this.tabFolder.setSelection(tabIndex);
        if (this.tabFolder.getItem(tabIndex) == this.portsTabItem) {
            this.portsText.forceFocus();
        }
        super.open();
    }

    @Override
    protected void populateShell() {
        this.shell.setText(Labels.getLabel("title.preferences"));
        this.shell.setLayout(LayoutHelper.formLayout(10, 10, 4));
        this.createTabFolder();
        this.okButton = new Button(this.shell, 0);
        this.okButton.setText(Labels.getLabel("button.OK"));
        this.cancelButton = new Button(this.shell, 0);
        this.cancelButton.setText(Labels.getLabel("button.cancel"));
        this.positionButtonsInFormLayout(this.okButton, this.cancelButton, this.tabFolder);
        this.shell.pack();
        this.okButton.setFocus();
        this.okButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (PreferencesDialog.this.shell != null && !PreferencesDialog.this.shell.isDisposed()) {
                    PreferencesDialog.this.savePreferences();
                    PreferencesDialog.this.close();
                }
            }
        });
        this.cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                PreferencesDialog.this.close();
            }
        });
    }

    private void createTabFolder() {
        this.tabFolder = new TabFolder(this.shell, 0);
        this.createScanningTab();
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText(Labels.getLabel("title.preferences.scanning"));
        tabItem.setControl(this.scanningTab);
        this.scanningTabItem = tabItem;
        this.createPortsTab();
        tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText(Labels.getLabel("title.preferences.ports"));
        tabItem.setControl(this.portsTab);
        this.portsTabItem = tabItem;
        this.createDisplayTab();
        tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText(Labels.getLabel("title.preferences.display"));
        tabItem.setControl(this.displayTab);
        this.tabFolder.pack();
    }

    private void createScanningTab() {
        RowLayout rowLayout = this.createRowLayout();
        this.scanningTab = new Composite(this.tabFolder, 0);
        this.scanningTab.setLayout(rowLayout);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        Group threadsGroup = new Group(this.scanningTab, 0);
        threadsGroup.setText(Labels.getLabel("preferences.threads"));
        threadsGroup.setLayout(groupLayout);
        GridData gridData = new GridData(80, -1);
        Label label = new Label(threadsGroup, 0);
        label.setText(Labels.getLabel("preferences.threads.delay"));
        this.threadDelayText = new Text(threadsGroup, 2048);
        this.threadDelayText.setLayoutData(gridData);
        label = new Label(threadsGroup, 0);
        label.setText(Labels.getLabel("preferences.threads.maxThreads"));
        this.maxThreadsText = new Text(threadsGroup, 2048);
        this.maxThreadsText.setLayoutData(gridData);
        Group pingingGroup = new Group(this.scanningTab, 0);
        pingingGroup.setLayout(groupLayout);
        pingingGroup.setText(Labels.getLabel("preferences.pinging"));
        label = new Label(pingingGroup, 0);
        label.setText(Labels.getLabel("preferences.pinging.type"));
        this.pingersCombo = new Combo(pingingGroup, 12);
        this.pingersCombo.setLayoutData(gridData);
        String[] pingerNames = this.pingerRegistry.getRegisteredNames();
        for (int i = 0; i < pingerNames.length; ++i) {
            this.pingersCombo.add(Labels.getLabel(pingerNames[i]));
            this.pingersCombo.setData(Integer.toString(i), pingerNames[i]);
        }
        this.pingersCombo.select(0);
        label = new Label(pingingGroup, 0);
        label.setText(Labels.getLabel("preferences.pinging.count"));
        this.pingingCountText = new Text(pingingGroup, 2048);
        this.pingingCountText.setLayoutData(gridData);
        label = new Label(pingingGroup, 0);
        label.setText(Labels.getLabel("preferences.pinging.timeout"));
        this.pingingTimeoutText = new Text(pingingGroup, 2048);
        this.pingingTimeoutText.setLayoutData(gridData);
        GridData gridDataWithSpan = new GridData();
        gridDataWithSpan.horizontalSpan = 2;
        this.deadHostsCheckbox = new Button(pingingGroup, 32);
        this.deadHostsCheckbox.setText(Labels.getLabel("preferences.pinging.deadHosts"));
        this.deadHostsCheckbox.setLayoutData(gridDataWithSpan);
        Group skippingGroup = new Group(this.scanningTab, 0);
        skippingGroup.setLayout(groupLayout);
        skippingGroup.setText(Labels.getLabel("preferences.skipping"));
        this.skipBroadcastsCheckbox = new Button(skippingGroup, 32);
        this.skipBroadcastsCheckbox.setText(Labels.getLabel("preferences.skipping.broadcast"));
        GridData gridDataWithSpan2 = new GridData();
        gridDataWithSpan2.horizontalSpan = 2;
        this.skipBroadcastsCheckbox.setLayoutData(gridDataWithSpan2);
    }

    private void createDisplayTab() {
        RowLayout rowLayout = this.createRowLayout();
        this.displayTab = new Composite(this.tabFolder, 0);
        this.displayTab.setLayout(rowLayout);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 1;
        Group listGroup = new Group(this.displayTab, 0);
        listGroup.setText(Labels.getLabel("preferences.display.list"));
        listGroup.setLayout(groupLayout);
        listGroup.setLayoutData(new RowData(260, -1));
        this.displayMethod = new Button[GUIConfig.DisplayMethod.values().length];
        Button allRadio = new Button(listGroup, 16);
        allRadio.setText(Labels.getLabel("preferences.display.list." + String.valueOf((Object)GUIConfig.DisplayMethod.ALL)));
        this.displayMethod[GUIConfig.DisplayMethod.ALL.ordinal()] = allRadio;
        Button aliveRadio = new Button(listGroup, 16);
        aliveRadio.setText(Labels.getLabel("preferences.display.list." + String.valueOf((Object)GUIConfig.DisplayMethod.ALIVE)));
        this.displayMethod[GUIConfig.DisplayMethod.ALIVE.ordinal()] = aliveRadio;
        Button portsRadio = new Button(listGroup, 16);
        portsRadio.setText(Labels.getLabel("preferences.display.list." + String.valueOf((Object)GUIConfig.DisplayMethod.PORTS)));
        this.displayMethod[GUIConfig.DisplayMethod.PORTS.ordinal()] = portsRadio;
        groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        Group labelsGroup = new Group(this.displayTab, 0);
        labelsGroup.setText(Labels.getLabel("preferences.display.labels"));
        labelsGroup.setLayout(groupLayout);
        GridData gridData = new GridData();
        gridData.widthHint = 50;
        Label label = new Label(labelsGroup, 0);
        label.setText(Labels.getLabel("preferences.display.labels.notAvailable"));
        this.notAvailableText = new Text(labelsGroup, 2048);
        this.notAvailableText.setLayoutData(gridData);
        label = new Label(labelsGroup, 0);
        label.setText(Labels.getLabel("preferences.display.labels.notScanned"));
        this.notScannedText = new Text(labelsGroup, 2048);
        this.notScannedText.setLayoutData(gridData);
        groupLayout = new GridLayout();
        groupLayout.numColumns = 1;
        Group showStatsGroup = new Group(this.displayTab, 0);
        showStatsGroup.setLayout(groupLayout);
        showStatsGroup.setText(Labels.getLabel("preferences.display.confirmation"));
        this.askConfirmationCheckbox = new Button(showStatsGroup, 32);
        this.askConfirmationCheckbox.setText(Labels.getLabel("preferences.display.confirmation.newScan"));
        this.showInfoCheckbox = new Button(showStatsGroup, 32);
        this.showInfoCheckbox.setText(Labels.getLabel("preferences.display.confirmation.showInfo"));
        groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        Group languageGroup = new Group(this.displayTab, 0);
        languageGroup.setLayout(groupLayout);
        languageGroup.setText(Labels.getLabel("preferences.language"));
        this.languageCombo = new Combo(languageGroup, 12);
        for (String language : Labels.LANGUAGES) {
            this.languageCombo.add(Labels.getLabel("language." + language));
        }
        this.languageCombo.select(0);
        label = new Label(languageGroup, 0);
        label.setText(Labels.getLabel("preferences.language.someIncomplete"));
        this.versionCheckCheckbox = new Button(this.displayTab, 32);
        this.versionCheckCheckbox.setText(Labels.getLabel("preferences.versionCheck"));
        this.allowReports = new Button(this.displayTab, 32);
        this.allowReports.setText(Labels.getLabel("preferences.allowReports"));
    }

    private void createPortsTab() {
        RowLayout rowLayout = this.createRowLayout();
        this.portsTab = new Composite(this.tabFolder, 0);
        this.portsTab.setLayout(rowLayout);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        Group timingGroup = new Group(this.portsTab, 0);
        timingGroup.setText(Labels.getLabel("preferences.ports.timing"));
        timingGroup.setLayout(groupLayout);
        GridData gridData = new GridData();
        gridData.widthHint = 50;
        Label label = new Label(timingGroup, 0);
        label.setText(Labels.getLabel("preferences.ports.timing.timeout"));
        this.portTimeoutText = new Text(timingGroup, 2048);
        this.portTimeoutText.setLayoutData(gridData);
        GridData gridData1 = new GridData();
        gridData1.horizontalSpan = 2;
        this.adaptTimeoutCheckbox = new Button(timingGroup, 32);
        this.adaptTimeoutCheckbox.setText(Labels.getLabel("preferences.ports.timing.adaptTimeout"));
        this.adaptTimeoutCheckbox.setLayoutData(gridData1);
        this.adaptTimeoutCheckbox.addListener(13, event -> this.minPortTimeoutText.setEnabled(this.adaptTimeoutCheckbox.getSelection()));
        label = new Label(timingGroup, 0);
        label.setText(Labels.getLabel("preferences.ports.timing.minTimeout"));
        this.minPortTimeoutText = new Text(timingGroup, 2048);
        this.minPortTimeoutText.setLayoutData(gridData);
        RowLayout portsLayout = new RowLayout(512);
        portsLayout.fill = true;
        portsLayout.marginHeight = 2;
        portsLayout.marginWidth = 2;
        Group portsGroup = new Group(this.portsTab, 0);
        portsGroup.setText(Labels.getLabel("preferences.ports.ports"));
        portsGroup.setLayout(portsLayout);
        label = new Label(portsGroup, 64);
        label.setText(Labels.getLabel("preferences.ports.portsDescription"));
        this.portsText = new Text(portsGroup, 2562);
        this.portsText.setLayoutData(new RowData(-1, 60));
        this.portsText.addKeyListener(new PortsTextValidationListener());
        this.addRequestedPortsCheckbox = new Button(portsGroup, 32);
        this.addRequestedPortsCheckbox.setText(Labels.getLabel("preferences.ports.addRequested"));
        this.addRequestedPortsCheckbox.setToolTipText(Labels.getLabel("preferences.ports.addRequested.info"));
    }

    private RowLayout createRowLayout() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.spacing = 9;
        rowLayout.marginHeight = 9;
        rowLayout.marginWidth = 11;
        rowLayout.fill = true;
        return rowLayout;
    }

    private void loadPreferences() {
        int i;
        this.maxThreadsText.setText(Integer.toString(this.scannerConfig.maxThreads));
        this.threadDelayText.setText(Integer.toString(this.scannerConfig.threadDelay));
        String[] pingerNames = this.pingerRegistry.getRegisteredNames();
        for (i = 0; i < pingerNames.length; ++i) {
            if (!this.scannerConfig.selectedPinger.equals(pingerNames[i])) continue;
            this.pingersCombo.select(i);
        }
        this.pingingCountText.setText(Integer.toString(this.scannerConfig.pingCount));
        this.pingingTimeoutText.setText(Integer.toString(this.scannerConfig.pingTimeout));
        this.deadHostsCheckbox.setSelection(this.scannerConfig.scanDeadHosts);
        this.skipBroadcastsCheckbox.setSelection(this.scannerConfig.skipBroadcastAddresses);
        this.portTimeoutText.setText(Integer.toString(this.scannerConfig.portTimeout));
        this.adaptTimeoutCheckbox.setSelection(this.scannerConfig.adaptPortTimeout);
        this.minPortTimeoutText.setText(Integer.toString(this.scannerConfig.minPortTimeout));
        this.minPortTimeoutText.setEnabled(this.scannerConfig.adaptPortTimeout);
        this.portsText.setText(this.scannerConfig.portString);
        this.addRequestedPortsCheckbox.setSelection(this.scannerConfig.useRequestedPorts);
        this.notAvailableText.setText(this.scannerConfig.notAvailableText);
        this.notScannedText.setText(this.scannerConfig.notScannedText);
        this.displayMethod[this.guiConfig.displayMethod.ordinal()].setSelection(true);
        this.showInfoCheckbox.setSelection(this.guiConfig.showScanStats);
        this.askConfirmationCheckbox.setSelection(this.guiConfig.askScanConfirmation);
        this.versionCheckCheckbox.setSelection(this.guiConfig.versionCheckEnabled);
        this.allowReports.setSelection(this.globalConfig.allowReports);
        for (i = 0; i < Labels.LANGUAGES.length; ++i) {
            if (!this.globalConfig.language.equals(Labels.LANGUAGES[i])) continue;
            this.languageCombo.select(i);
        }
    }

    private void savePreferences() {
        try {
            new PortIterator(this.portsText.getText());
        }
        catch (Exception e) {
            this.tabFolder.setSelection(this.portsTabItem);
            this.portsText.forceFocus();
            throw new FetcherException("unparseablePortString", e);
        }
        this.scannerConfig.selectedPinger = (String)this.pingersCombo.getData(Integer.toString(this.pingersCombo.getSelectionIndex()));
        this.scannerConfig.maxThreads = PreferencesDialog.parseIntValue(this.maxThreadsText);
        this.scannerConfig.threadDelay = PreferencesDialog.parseIntValue(this.threadDelayText);
        this.scannerConfig.pingCount = PreferencesDialog.parseIntValue(this.pingingCountText);
        this.scannerConfig.pingTimeout = PreferencesDialog.parseIntValue(this.pingingTimeoutText);
        this.scannerConfig.scanDeadHosts = this.deadHostsCheckbox.getSelection();
        this.scannerConfig.skipBroadcastAddresses = this.skipBroadcastsCheckbox.getSelection();
        this.scannerConfig.portTimeout = PreferencesDialog.parseIntValue(this.portTimeoutText);
        this.scannerConfig.adaptPortTimeout = this.adaptTimeoutCheckbox.getSelection();
        this.scannerConfig.minPortTimeout = PreferencesDialog.parseIntValue(this.minPortTimeoutText);
        this.scannerConfig.portString = this.portsText.getText();
        this.scannerConfig.useRequestedPorts = this.addRequestedPortsCheckbox.getSelection();
        this.scannerConfig.notAvailableText = this.notAvailableText.getText();
        this.scannerConfig.notScannedText = this.notScannedText.getText();
        for (int i = 0; i < this.displayMethod.length; ++i) {
            if (!this.displayMethod[i].getSelection()) continue;
            this.guiConfig.displayMethod = GUIConfig.DisplayMethod.values()[i];
        }
        this.guiConfig.showScanStats = this.showInfoCheckbox.getSelection();
        this.guiConfig.askScanConfirmation = this.askConfirmationCheckbox.getSelection();
        this.guiConfig.versionCheckEnabled = this.versionCheckCheckbox.getSelection();
        this.globalConfig.allowReports = this.allowReports.getSelection();
        String newLanguage = Labels.LANGUAGES[this.languageCombo.getSelectionIndex()];
        if (!newLanguage.equals(this.globalConfig.language)) {
            this.globalConfig.language = newLanguage;
            MessageBox msgBox = new MessageBox(this.shell);
            msgBox.setMessage(Labels.getLabel("preferences.language.needsRestart"));
            msgBox.open();
        }
    }

    private static int parseIntValue(Text text) {
        try {
            return Integer.parseInt(text.getText());
        }
        catch (NumberFormatException e) {
            text.forceFocus();
            throw e;
        }
    }

    static class PortsTextValidationListener
    implements KeyListener {
        PortsTextValidationListener() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void keyPressed(KeyEvent e) {
            Text portsText = (Text)e.getSource();
            if (e.keyCode == 9) {
                portsText.getShell().traverse(16);
                e.doit = false;
                return;
            }
            if (e.keyCode == 13) {
                if ((e.stateMask & SWT.MOD1) <= 0) {
                    portsText.getShell().traverse(4);
                    e.doit = false;
                    return;
                }
                e.stateMask = 0;
            } else if (Character.isISOControl(e.character)) {
                return;
            }
            e.doit = this.validateChar(e.character, portsText.getText(), portsText.getCaretPosition());
        }

        boolean validateChar(char c, String text, int caretPos) {
            char pc = '\u0000';
            for (int i = caretPos - 1; i >= 0 && Character.isWhitespace(pc = text.charAt(i)); --i) {
            }
            boolean isCurDigit = c >= '0' && c <= '9';
            boolean isPrevDigit = pc >= '0' && pc <= '9';
            return isPrevDigit && (isCurDigit || c == '-' || c == ',') || isCurDigit && (pc == '-' || pc == ',' || pc == '\u0000') || Character.isWhitespace(c) && pc == ',';
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

