/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import java.util.logging.Logger;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.gui.util.LayoutHelper;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractModalDialog {
    protected Shell shell;
    private static Image icon;

    public void open() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.createShell();
        }
        if (this.shell.getParent() != null) {
            Rectangle parentBounds = this.shell.getParent().getBounds();
            Rectangle childBounds = this.shell.getBounds();
            int x = Math.max(0, parentBounds.x + (parentBounds.width - childBounds.width) / 2);
            int y = Math.max(0, parentBounds.y + (parentBounds.height - childBounds.height) / 2);
            this.shell.setLocation(x, y);
        }
        this.shell.open();
        Display display = Display.getCurrent();
        while (this.shell != null && !this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.shell = null;
    }

    protected void close() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
            this.shell.dispose();
        }
    }

    protected abstract void populateShell();

    protected final void createShell() {
        Shell parent = null;
        try {
            parent = Display.getCurrent().getShells()[0];
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).warning("Failed to get parent shell: " + String.valueOf(e));
        }
        this.shell = new Shell(parent, this.getShellStyle());
        if (icon == null && parent != null) {
            icon = parent.getImage();
        }
        if (icon == null) {
            icon = new Image((Device)this.shell.getDisplay(), this.getClass().getResourceAsStream("/images/icon.png"));
        }
        this.shell.setImage(icon);
        this.populateShell();
    }

    protected int getShellStyle() {
        return 67680;
    }

    protected void positionButtons(Button okButton, Button cancelButton) {
        this.shell.setDefaultButton(okButton);
        Rectangle clientArea = this.shell.getClientArea();
        Point size = okButton.computeSize(85, -1);
        okButton.setSize(size);
        if (cancelButton != null) {
            cancelButton.setSize(size);
            if (Platform.MAC_OS || Platform.LINUX) {
                Button fooButton = okButton;
                okButton = cancelButton;
                cancelButton = fooButton;
            }
            int distance = size.y / 3;
            cancelButton.setLocation(clientArea.width - size.x - 10, clientArea.height - size.y - 10);
            okButton.setLocation(clientArea.width - size.x * 2 - 10 - distance, clientArea.height - size.y - 10);
        } else {
            okButton.setLocation(clientArea.width - size.x - 10, clientArea.height - size.y - 10);
        }
    }

    protected void positionButtonsInFormLayout(Button okButton, Button cancelButton, Control control) {
        this.shell.setDefaultButton(okButton);
        if (Platform.MAC_OS || Platform.LINUX) {
            Button fooButton = okButton;
            okButton = cancelButton;
            cancelButton = fooButton;
        }
        cancelButton.pack();
        cancelButton.setLayoutData(LayoutHelper.formData(Math.max(85, cancelButton.getSize().x), -1, null, new FormAttachment(control, 0, 131072), new FormAttachment(control, 8), null));
        okButton.pack();
        Point okSize = okButton.getSize();
        okButton.setLayoutData(LayoutHelper.formData(Math.max(85, okSize.x), -1, null, new FormAttachment(cancelButton, -okSize.y / 3), new FormAttachment(control, 8), null));
    }

    protected Button createCloseButton() {
        Button button = new Button(this.shell, 0);
        button.setText(Labels.getLabel("button.close"));
        this.positionButtons(button, null);
        button.addListener(13, event -> this.close());
        button.setFocus();
        return button;
    }

    protected static class DownButtonListener
    implements Listener {
        private List list;

        public DownButtonListener(List list) {
            this.list = list;
        }

        @Override
        public void handleEvent(Event event) {
            if (this.list.getSelectionCount() == 0 || this.list.isSelected(this.list.getItemCount() - 1)) {
                return;
            }
            int[] selectedItems = this.list.getSelectionIndices();
            for (int i = selectedItems.length - 1; i >= 0; --i) {
                int index = selectedItems[i];
                this.list.deselect(index);
                String oldItem = this.list.getItem(index + 1);
                this.list.setItem(index + 1, this.list.getItem(index));
                this.list.setItem(index, oldItem);
                this.list.select(index + 1);
            }
            if (!Platform.MAC_OS) {
                this.list.setTopIndex(selectedItems[0]);
            }
        }
    }

    protected static class UpButtonListener
    implements Listener {
        private List list;

        public UpButtonListener(List list) {
            this.list = list;
        }

        @Override
        public void handleEvent(Event event) {
            int[] selectedItems;
            if (this.list.getSelectionCount() == 0 || this.list.isSelected(0)) {
                return;
            }
            for (int index : selectedItems = this.list.getSelectionIndices()) {
                this.list.deselect(index);
                String oldItem = this.list.getItem(index - 1);
                this.list.setItem(index - 1, this.list.getItem(index));
                this.list.setItem(index, oldItem);
                this.list.select(index - 1);
            }
            if (!Platform.MAC_OS) {
                this.list.setTopIndex(selectedItems[0] - 2);
            }
        }
    }
}

