/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import java.util.SortedSet;
import net.azib.ipscan.config.ScannerConfig;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.values.NotScanned;
import net.azib.ipscan.core.values.NumericRangeList;
import net.azib.ipscan.fetchers.PortsFetcher;

public class FilteredPortsFetcher
extends PortsFetcher {
    public FilteredPortsFetcher(ScannerConfig scannerConfig) {
        super(scannerConfig);
    }

    @Override
    public String getId() {
        return "fetcher.ports.filtered";
    }

    @Override
    public Object scan(ScanningSubject subject) {
        boolean portsScanned = this.scanPorts(subject);
        if (!portsScanned) {
            return NotScanned.VALUE;
        }
        SortedSet<Integer> filteredPorts = this.getFilteredPorts(subject);
        return filteredPorts.size() > 0 ? new NumericRangeList(filteredPorts, this.displayAsRanges) : null;
    }
}

