/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import net.azib.ipscan.fetchers.Fetcher;
import net.azib.ipscan.fetchers.FetcherException;
import net.azib.ipscan.fetchers.FetcherPrefs;
import net.azib.ipscan.fetchers.FetcherRegistryUpdateListener;
import net.azib.ipscan.gui.PreferencesDialog;

public class FetcherRegistry {
    private final Preferences preferences;
    private final PreferencesDialog preferencesDialog;
    private Map<String, Fetcher> registeredFetchers;
    private Map<String, Fetcher> selectedFetchers;
    private List<FetcherRegistryUpdateListener> updateListeners = new ArrayList<FetcherRegistryUpdateListener>();

    public FetcherRegistry(List<Fetcher> fetchers, Preferences preferences, PreferencesDialog preferencesDialog) {
        this.preferences = preferences;
        this.preferencesDialog = preferencesDialog;
        this.registeredFetchers = this.createFetchersMap(fetchers);
        this.loadSelectedFetchers(preferences);
    }

    private Map<String, Fetcher> createFetchersMap(List<Fetcher> fetchers) {
        LinkedHashMap<String, Fetcher> registeredFetchers = new LinkedHashMap<String, Fetcher>(fetchers.size());
        for (Fetcher fetcher : fetchers) {
            registeredFetchers.put(fetcher.getId(), fetcher);
        }
        return Collections.unmodifiableMap(registeredFetchers);
    }

    private void loadSelectedFetchers(Preferences preferences) {
        String fetcherPrefValue = preferences.get("selectedFetchers", null);
        if (fetcherPrefValue == null) {
            this.selectedFetchers = new LinkedHashMap<String, Fetcher>();
            this.selectedFetchers.put("fetcher.ip", this.registeredFetchers.get("fetcher.ip"));
            this.selectedFetchers.put("fetcher.ping", this.registeredFetchers.get("fetcher.ping"));
            this.selectedFetchers.put("fetcher.hostname", this.registeredFetchers.get("fetcher.hostname"));
            this.selectedFetchers.put("fetcher.ports", this.registeredFetchers.get("fetcher.ports"));
        } else {
            String[] fetcherPrefs = fetcherPrefValue.split("###");
            this.selectedFetchers = new LinkedHashMap<String, Fetcher>(this.registeredFetchers.size());
            for (String fetcherPref : fetcherPrefs) {
                Fetcher fetcher = this.registeredFetchers.get(fetcherPref);
                if (fetcher == null) continue;
                this.selectedFetchers.put(fetcherPref, fetcher);
            }
        }
    }

    private void saveSelectedFetchers(Preferences preferences) {
        StringBuilder sb = new StringBuilder();
        for (String fetcherName : this.selectedFetchers.keySet()) {
            sb.append(fetcherName).append("###");
        }
        String value = sb.toString();
        if (value.endsWith("###")) {
            value = value.substring(0, value.length() - 3);
        }
        preferences.put("selectedFetchers", value);
    }

    public void addListener(FetcherRegistryUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public Collection<Fetcher> getRegisteredFetchers() {
        return this.registeredFetchers.values();
    }

    public Collection<Fetcher> getSelectedFetchers() {
        return this.selectedFetchers.values();
    }

    public int getSelectedFetcherIndex(String id) {
        int index = 0;
        for (Fetcher fetcher : this.selectedFetchers.values()) {
            if (id.equals(fetcher.getId())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void updateSelectedFetchers(String[] labels) {
        LinkedHashMap<String, Fetcher> newList = new LinkedHashMap<String, Fetcher>();
        for (String label : labels) {
            newList.put(label, this.registeredFetchers.get(label));
        }
        this.selectedFetchers = newList;
        for (FetcherRegistryUpdateListener listener : this.updateListeners) {
            listener.handleUpdateOfSelectedFetchers(this);
        }
        this.saveSelectedFetchers(this.preferences);
    }

    public void openPreferencesEditor(Fetcher fetcher) throws FetcherException {
        Class<? extends FetcherPrefs> prefsEditorClass = fetcher.getPreferencesClass();
        if (prefsEditorClass == null) {
            throw new FetcherException("preferences.notAvailable");
        }
        try {
            FetcherPrefs prefs = this.createFetcherPrefsEditor(prefsEditorClass);
            prefs.openFor(fetcher);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate fetcher preference editor: " + prefsEditorClass.getName(), e);
        }
    }

    private FetcherPrefs createFetcherPrefsEditor(Class<? extends FetcherPrefs> prefsClass) throws Exception {
        try {
            Constructor<? extends FetcherPrefs> constructor = prefsClass.getConstructor(PreferencesDialog.class);
            return constructor.newInstance(this.preferencesDialog);
        }
        catch (NoSuchMethodException e) {
            return prefsClass.newInstance();
        }
    }
}

