/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.exporters;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.Version;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.exporters.AbstractExporter;
import net.azib.ipscan.gui.feeders.AbstractFeederGUI;
import net.azib.ipscan.util.IOUtils;
import net.azib.ipscan.util.InetAddressUtils;

public class TXTExporter
extends AbstractExporter {
    int[] padLengths;

    @Override
    public String getId() {
        return "exporter.txt";
    }

    @Override
    public String getFilenameExtension() {
        return "txt";
    }

    @Override
    public void start(OutputStream outputStream, String feederInfo) throws IOException {
        super.start(outputStream, feederInfo);
        if (!this.append) {
            this.output.print(Labels.getLabel("exporter.txt.generated"));
            this.output.print(' ');
            this.output.println(Version.getFullName());
            this.output.println("https://angryip.org");
            this.output.println();
            this.output.print(Labels.getLabel("exporter.txt.scanned"));
            this.output.print(' ');
            this.output.println(feederInfo);
            this.output.println(DateFormat.getDateTimeInstance().format(new Date()));
            this.output.println();
        }
    }

    @Override
    public void setFetchers(String[] fetcherNames) throws IOException {
        this.padLengths = new int[fetcherNames.length];
        for (int i = 0; i < fetcherNames.length; ++i) {
            this.padLengths[i] = fetcherNames[i].length() * 3;
            if (this.append) continue;
            this.output.write(this.pad(fetcherNames[i], this.padLengths[i]));
        }
        if (!this.append) {
            this.output.println();
        }
    }

    @Override
    public void nextAddressResults(Object[] results) throws IOException {
        this.output.write(this.pad(results[0], this.padLengths[0]));
        for (int i = 1; i < results.length; ++i) {
            Object result = results[i];
            this.output.write(this.pad(result, this.padLengths[i]));
        }
        this.output.println();
    }

    String pad(Object o, int length) {
        String s;
        if (length < 16) {
            length = 16;
        }
        if ((s = o == null ? "" : o.toString()).length() >= length) {
            return s;
        }
        return s + "                                                                       ".substring(0, length - s.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ScanningResult> importResults(String fileName, AbstractFeederGUI feeder) throws IOException {
        ArrayList<ScanningResult> arrayList;
        ArrayList<ScanningResult> results = new ArrayList<ScanningResult>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(fileName));
            String startIP = null;
            String endIP = null;
            String lastLoadedIP = null;
            List<Object> columns = Collections.emptyList();
            int ipIndex = 0;
            int pingIndex = 1;
            int portsIndex = 3;
            String[] lookingFor = new String[]{Labels.getLabel("exporter.txt.scanned"), Labels.getLabel("fetcher.ip")};
            int lookingForIndex = 0;
            while ((line = reader.readLine()) != null) {
                Object[] sp;
                if (lookingForIndex < lookingFor.length) {
                    sp = line.split("\\s");
                    if (!lookingFor[lookingForIndex].equals(sp[0])) continue;
                    if (lookingForIndex == 0) {
                        startIP = sp[1];
                        endIP = sp[3];
                        ++lookingForIndex;
                        continue;
                    }
                    if (lookingForIndex != 1) continue;
                    sp = line.split("\\s{2,}");
                    columns = Arrays.asList(sp);
                    pingIndex = columns.indexOf(Labels.getLabel("fetcher.ping"));
                    portsIndex = columns.indexOf(Labels.getLabel("fetcher.ports"));
                    ++lookingForIndex;
                    continue;
                }
                sp = line.split("\\s{2,}");
                if (sp.length < columns.size()) continue;
                InetAddress addr = InetAddress.getByName(sp[ipIndex]);
                lastLoadedIP = sp[ipIndex];
                ScanningResult r = new ScanningResult(addr, sp.length);
                if (portsIndex > 0 && sp[portsIndex].matches("\\d.*")) {
                    r.setType(ScanningResult.ResultType.WITH_PORTS);
                } else if (pingIndex > 0 && sp[pingIndex].matches("\\d.*")) {
                    r.setType(ScanningResult.ResultType.ALIVE);
                } else {
                    r.setType(ScanningResult.ResultType.DEAD);
                }
                r.setValues(sp);
                results.add(r);
            }
            if (lastLoadedIP != null && !lastLoadedIP.equals(endIP)) {
                InetAddress nextStartIP = InetAddressUtils.increment(InetAddress.getByName(lastLoadedIP));
                startIP = nextStartIP.getHostAddress();
            }
            feeder.unserialize(startIP, endIP);
            arrayList = results;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        return arrayList;
    }
}

