/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.di;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.azib.ipscan.di.InjectException;

public class Injector {
    private final Map<Class<?>, Object> instances = new LinkedHashMap();

    public Injector() {
        this.register(Injector.class, this);
    }

    public <T> void register(Class<T> type, T impl) {
        this.instances.put(type, impl);
    }

    public <T> T require(Class<T> type) {
        Object value = this.instances.get(type);
        if (value == null) {
            value = this.createInstance(type);
            this.instances.put(type, value);
        }
        return (T)value;
    }

    public void register(Class<?> ... types) {
        Arrays.stream(types).forEach(this::require);
    }

    public <T> List<T> requireAll(Class<T> type) {
        return this.instances.entrySet().stream().filter(e -> type.isAssignableFrom((Class)e.getKey())).map(e -> e.getValue()).collect(Collectors.toList());
    }

    private <T> T createInstance(Class<T> type) {
        Constructor constructor = Arrays.stream(type.getConstructors()).max(Comparator.comparing(Constructor::getParameterCount)).orElseThrow(() -> new InjectException("No public constructors"));
        try {
            return constructor.newInstance(this.resolveDeps(constructor));
        }
        catch (Throwable e) {
            throw new InjectException("Cannot create " + type.getName() + ", deps: " + Arrays.toString(constructor.getGenericParameterTypes()), e);
        }
    }

    private Object[] resolveDeps(Constructor<?> constructor) {
        return Arrays.stream(constructor.getGenericParameterTypes()).map(t -> this.isCollection((Type)t) ? this.requireAll(this.collectionItemType((Type)t)) : this.require(this.toClass((Type)t))).toArray();
    }

    private Class<?> toClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        throw new InjectException(String.valueOf(type) + " is not supported");
    }

    private boolean isCollection(Type type) {
        return type instanceof ParameterizedType && Collection.class.isAssignableFrom(this.toClass(type));
    }

    private Class<?> collectionItemType(Type type) {
        return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
    }
}

