/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LibraryLoader {
    public static void loadLibrary(String library) {
        String filename = System.mapLibraryName(library);
        String fullFilename = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + filename;
        try {
            System.load(fullFilename);
        }
        catch (UnsatisfiedLinkError err2) {
            try {
                int read;
                InputStream is = LibraryLoader.class.getClassLoader().getResourceAsStream(filename);
                if (is == null) {
                    throw new IOException(filename + " not found in the jar file (classpath)");
                }
                byte[] buffer = new byte[4096];
                FileOutputStream os = new FileOutputStream(fullFilename);
                while ((read = is.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, read);
                }
                ((OutputStream)os).close();
                is.close();
                new File(fullFilename).setExecutable(true, false);
                System.load(fullFilename);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to extract native library: " + library, ioe);
            }
        }
    }
}

