/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.config;

import java.util.Locale;
import java.util.Random;
import java.util.prefs.Preferences;
import net.azib.ipscan.config.FavoritesConfig;
import net.azib.ipscan.config.GUIConfig;
import net.azib.ipscan.config.OpenersConfig;
import net.azib.ipscan.config.ScannerConfig;

public final class Config {
    private Preferences preferences = Preferences.userRoot().node("ipscan");
    public String language;
    public String gaClientId;
    public boolean allowReports;
    private ScannerConfig scannerConfig = new ScannerConfig(this.preferences);
    private GUIConfig guiConfig = new GUIConfig(this.preferences);
    private FavoritesConfig favoritesConfig = new FavoritesConfig(this.preferences);
    private OpenersConfig openersConfig = new OpenersConfig(this.preferences);

    Config() {
        this.language = this.preferences.get("language", "system");
        this.gaClientId = this.preferences.get("gaClientId", null);
        if (this.gaClientId == null) {
            Random random = new Random();
            long firstPart = 1000000000L + (long)(random.nextDouble() * 9.0E9);
            long secondPart = 1000000000L + (long)(random.nextDouble() * 9.0E9);
            this.gaClientId = firstPart + "." + secondPart;
            this.preferences.put("gaClientId", this.gaClientId);
        }
        this.allowReports = this.preferences.getBoolean("allowReports", true);
    }

    public static Config getConfig() {
        return ConfigHolder.INSTANCE;
    }

    public void store() {
        this.preferences.put("language", this.language);
        this.preferences.putBoolean("allowReports", this.allowReports);
        this.scannerConfig.store();
        this.guiConfig.store();
        this.favoritesConfig.store();
        this.openersConfig.store();
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public ScannerConfig forScanner() {
        return this.scannerConfig;
    }

    FavoritesConfig forFavorites() {
        return this.favoritesConfig;
    }

    public OpenersConfig forOpeners() {
        return this.openersConfig;
    }

    public GUIConfig forGUI() {
        return this.guiConfig;
    }

    public Locale getLocale() {
        if (this.language == null || "system".equals(this.language)) {
            return System.getProperty("locale") == null ? Locale.getDefault() : this.createLocale(System.getProperty("locale"));
        }
        return this.createLocale(this.language);
    }

    private Locale createLocale(String locale) {
        return Locale.forLanguageTag(locale.replace('_', '-'));
    }

    public String getGaClientId() {
        return this.gaClientId;
    }

    private static class ConfigHolder {
        static final Config INSTANCE = new Config();
    }
}

